package NotifyRule;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Carp;
use JSON;

use lib::abs qw(
  ../lib
  );

use Util;

sub new {
    my ($self, %opts) = @_;

    my $class = ref($self) || $self;

    return bless \%opts, $class;
}

sub create {
    my ($self, $pja) = @_;

    my $rule = $self->get_notify_rule();

    $pja->add_or_update_notify_rule(%$rule);
}

sub notification_tag {
    die 'Override sub notification_tag!';
}

sub logins {
    my ($self) = @_;
    return [
        '@svc_partnjorskijjinterfejjsjandeksa:backend_bugs_duty',
        '@svc_partnjorskijjinterfejjsjandeksa:backend_support_duty',
        @{$self->{logins} // []},
    ];
}

sub day_start {
    return 1;
}

sub day_end {
    return 7;
}

sub time_start {
    return '10:00';
}

sub time_end {
    return '23:00';
}

sub template_name {
    return 'phone_escalation';
}

sub time_frame_kwargs {
    my ($self) = @_;
    return (
        "day_start" => $self->day_start,
        "day_end" => $self->day_end,
        "time_start" => $self->time_start,
        "time_end"   => $self->time_end,
    );
}

sub delay {
    my ($self) = @_;
    return 300;
}

sub restart_after {
    my ($self) = @_;
    return 86400;
}

sub template_kwargs {
    my ($self) = @_;
    return {
        $self->time_frame_kwargs(),
        "restart_after" => $self->restart_after(),
        "repeat" => 2,
        "delay" => $self->delay(),
        "logins" => $self->logins(),
    };
}

sub get_notify_rule {
    my ($self) = @_;
    my $notification_tag = $self->notification_tag();
    return {
        "match_raw_events" => JSON::false,
        "namespace" => "partner.prod",
        "selector" => "(namespace=partner.prod | namespace=partner.preprod | namespace=partner.test | namespace=partner) & tag=$notification_tag",
        "template_name" => $self->template_name(),
        "template_kwargs" => $self->template_kwargs(),
        "check_kwargs" => {},
        "description" => 'https://wiki.yandex-team.ru/partner/w/juggler-checks/',
    };
}

1;
