package NotifyRule::SupportNotification;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(NotifyRule);
# https://staff.yandex-team.ru/departments/yandex_monetize_network_adfox_support
#
my @LOGIN_LIST_SUPPORT_DEP = qw(ilucy akh-natasha mrolegb yalev guru-veronika sdarvay lyuks87 o-maximova ruslan95 marker1k soinartem);
# https://staff.yandex-team.ru/departments/yandex_biz_com_sales_partner_support/
my @LOGIN_LIST_SALES_DEP = qw(shindyapka aagarev kartamysheva novak-sv osh);

sub notification_tag {
    return 'support-notification';
}

sub logins {
    my ($self) = @_;
    return [@{$self->{'logins'} // []}, @LOGIN_LIST_SUPPORT_DEP, @LOGIN_LIST_SALES_DEP];
}

sub template_name {
    return 'on_status_change';
}

sub template_kwargs {
    my ($self) = @_;
    return {
        $self->time_frame_kwargs(),
        "login"  => $self->logins(),
        "status" => ["CRIT"],
        "method" => ["phone"],
        "delay"  => 600,
        "repeat" => 86400,
    };
}

1;
