package NotifyRule::SupportTgNotification;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(NotifyRule);

my @SUPPORT_TELEGRAM_CHANELS = qw(pi-support-group);

sub notification_tag {
    return 'support-tg-notification';
}

sub logins {
    my ($self) = @_;
    return [@{$self->{'logins'} // []}, @SUPPORT_TELEGRAM_CHANELS];
}

sub template_name {
    return 'on_status_change';
}

sub template_kwargs {
    my ($self) = @_;
    return {
        $self->time_frame_kwargs(),
        "login"  => $self->logins(),
        "status" => ["CRIT"],
        "method" => ["telegram"],
        "delay"  => 600,
        "repeat" => 86400,
    };
}

1;
