use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use lib::abs qw(
  ../lib/
  );

use Yandex::Blackbox;
use Yandex::TVM qw(get_x_ya_service_ticket);

use FormConstants qw(
  $TVM_BLACKBOX_ID
  );
use Data::Dumper;

my ($session_id, $user_ip, $host) = @ARGV;
die "usage: $0 <session_id> <user_ip> <host>" unless $session_id && $user_ip && $host;

my $yb = Yandex::Blackbox->new(
    url                 => $ENV{FORM_BLACKBOX},
    x_ya_service_ticket => get_x_ya_service_ticket($TVM_BLACKBOX_ID),
);

my $data = $yb->sessionid(
    sessionid    => $session_id,
    sslsessionid => $session_id,
    userip       => $user_ip,
    host         => $host,
);

print Dumper($data);
