use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Carp;
use Cpanel::JSON::XS;
use Data::Dumper;
use Path::Tiny;

$Data::Dumper::Sortkeys = 1;

use Branches;
use FormConstants qw(
  %PROJECTS
  $PARTNER2_CRON_MAIL
  $PARTNERS_MAIL
  );
use Partner2;
use Submit;
use Utils;

$| = 1;

foreach my $user_id (@ARGV) {
    unless (
        eval {
            my $partner2_user_data = get_partner2_user_data($user_id);
            my $form_data          = $partner2_user_data->{db}{form_data};
            my $client_id          = $form_data->{client_id};
            my $person_id          = $form_data->{person_id};
            my $country_id         = $form_data->{country_id};
            my $branch_id          = $form_data->{branch_id};
            my $json_data          = $form_data->{data};
            croak qq[Got "form_data.data" : null for user_id $user_id] unless $json_data;
            my $data     = Cpanel::JSON::XS->new->decode($json_data);
            my $project  = $data->{project};
            my $contract = $data->{contract};
            my $fields   = $data->{fields};
            my $language = $data->{language};
            my $branches = Branches->new($project ? (project => $project) : ());

            my $form = Submit::_get_converted_fields(
                converter => $branches->get_converter_form($branch_id),
                fields    => $fields,
            );

            my %partner = (
                user_id => $user_id,
                %{
                    Submit::_get_converted_fields(
                        converter => $branches->get_converter_partner2($branch_id),
                        fields    => $fields,
                    )
                  },
                Submit::_specific_fields_for_partner_creation($project, $branch_id, $country_id, $branches),
            );
            create_or_update_partner(%partner);

            if ($branch_id !~ /part2$/) {
                send_email(
                    bcc     => $PARTNER2_CRON_MAIL,
                    body    => path('/data/mail_after_submission.html')->slurp(),
                    subject => gettext('Добро пожаловать в РСЯ', $language),
                    user_id => $user_id,
                );
            }

            print "$user_id\t OK\n";
            return 1;
        }
      )
    {
        my $err = $@;
        warn '-' x 40, "\n";
        warn "Error while processing user: $user_id\n";
        warn "$err\n";
        warn '-' x 40, "\n";
    }
}
