use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Getopt::Long;
use Data::Dumper;

use Partner2;
use TestSubmit;
use Utils;

my %opts;
GetOptions(\%opts, 'uid=i', 'client_id=i', 'login=s', 'version=s', 'submit_data=s', 'delete!',);

my @sqls = (
    'delete from form_data where user_id = ?;',
    'delete from users_action_log where elem_id = ?;',
    'delete from user_role where user_id = ?;',
'delete from context_on_site_campaign_action_log where elem_id in (select id from context_on_site_campaign where owner_id = ?);',
    'delete from context_on_site_campaign where owner_id = ?;',
    'delete from owner_site where user_id = ?;',
    'delete from site_action_log where user_id = ?;',
    'delete from user_adfox where user_id = ?;',
    'delete from mail_notification where user_id = ?;',
    'delete from common_offer_allowed_users where user_id = ?;',
    'delete from user_features where user_id = ?;',
    'delete from users where id = ?;',
);

sub main {
    say 'Got opts';
    say Dumper(\%opts);
    if ($opts{delete}) {
        say "Deleting user $opts{uid} from partner2 db";
        eval {
            rm_user_in_db($opts{uid});
            say "User $opts{uid} deleted from partner2 db";
        } or do {
            say sprintf("intapi/form/rm_user_in_db.json failed: %s", (ref($@) eq 'HASH' ? $@->{message} : $@));
            say "To delete user $opts{uid} from partner2 db execute:";
            say '--- SQL --';
            for (@sqls) {
                s/\?/$opts{uid}/;
                say;
            }
            say '--- SQL --';
        };
        unless ($opts{client_id}) {
            say "Requesting client_id for user $opts{uid} from partner2";
            $opts{client_id} = get_client_id($opts{uid});
            say "Got client_id for user $opts{uid}: $opts{client_id}";
        }
        remove_user_client_association(
            operator_user_id => $opts{uid},
            client_id        => $opts{client_id},
            user_id          => $opts{uid},
        );
        say "User $opts{uid} unlinked with $opts{client_id}";
        return;
    }

    my $data = get_data_from_json_file($opts{submit_data});

    $data->{user}{id}    = $opts{uid};
    $data->{user}{login} = $opts{login};

    is_submit_ok('Manual', $opts{uid}, $opts{login}, $data, 0, $opts{version},);
}

main();

1;
