#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Cpanel::JSON::XS;
use File::Slurp qw(read_file write_file);
use FindBin;
use Storable 'dclone';
use Test::More;
use Test::Mojo;
use Mojo::Util qw(monkey_patch);

use lib "$FindBin::Bin/../../t_lib/ $FindBin::Bin/../../local/lib/perl5/ $FindBin::Bin/../../api/lib";

use Mock::Subs;

require "$FindBin::Bin/app.psgi";

my $tjson_file = $ARGV[0];
my ($shebang, @lines) = read_file($tjson_file);
my $tjson      = decode_json join("", @lines);
my $t          = Test::Mojo->new;
my $old_listen = \&{*Mojo::Server::Daemon::listen};
monkey_patch 'Mojo::Server::Daemon', listen => sub {
    if (ref($_[1]) eq 'ARRAY') {
        for my $i (0 .. $#{$_[1]}) {
            my $mojo_url = Mojo::URL->new($_[1]->[$i]);
            if ($mojo_url->host eq '127.0.0.1') {
                $_[1]->[$i] = $mojo_url->host('localhost')->to_string;
            }
        }
    }
    return $old_listen->(@_);
};
my $old_connect = \&{*Mojo::IOLoop::Client::_connect};
monkey_patch 'Mojo::IOLoop::Client', _connect => sub {
    if (ref($_[1]) eq 'HASH') {
        for my $key (qw(socks_address address)) {
            if (exists($_[1]->{$key}) && ($_[1]->{$key} // '') eq '127.0.0.1') {
                $_[1]->{$key} = 'localhost';
            }
        }
    }
    return $old_connect->(@_);
};

my $name = $tjson->{name} || $tjson_file;
my $n = 0;
for my $test (@{$tjson->{tests}}) {
    $n++;
    my $tname = ($test->{name} || sprintf('%s [%d]', $name, $n));
    subtest $tname => sub {
        my $tests = 3;    # request, status, body
        my $request =
          ($ENV{SELF_UPDATE} ? dclone($test->{request}) : $test->{request})
          ;               # sometimes build_tx (or deepper) corrupts structure

        my $mock = Mock::Subs->new();

        if ($request->{blackbox_mock_data}) {
            $mock->mock('Yandex::Blackbox::sessionid', 'return' => $request->{blackbox_mock_data});
        } else {
            $mock->mock(
                'Yandex::Blackbox::sessionid',
                'return' => {
                    'login'  => 'BeS.teST-024',
                    'status' => {'id' => 0},
                    'uid'    => {'value' => '607369863'},
                }
            );
        }

        if ($request->{form_version}) {
            $mock->mock('Partner2::get_form_version', 'return' => $request->{form_version});
            $mock->mock('main::get_form_version',     'return' => $request->{form_version});
        } else {
            $mock->mock('Partner2::get_form_version', 'return' => 2);
            $mock->mock('main::get_form_version',     'return' => 2);
        }

        $mock->mock('main::send_to_sentry',        'return' => 'mocked_sentry_id');
        $mock->mock('Partner2::get_client_id',     'return' => 607369863);
        $mock->mock('Monitoring::send_to_solomon', 'return' => 1);

        if (ref $request->{mock_subs} eq 'ARRAY') {
            $mock->mock($_) foreach (@{$request->{mock_subs}});
        } elsif (ref $request->{mock_subs} eq 'HASH') {
            foreach my $sub_name (keys %{$request->{mock_subs}}) {
                my %opts = (ref $request->{mock_subs}{$sub_name} eq 'HASH' ? %{$request->{mock_subs}{$sub_name}} : ());
                $mock->mock($sub_name, %opts);
                $tests++ if ($opts{test_pass});
            }
        }

        foreach my $r (@{$request->{files}}) {
            my $name   = $r->{name};
            my $data   = $r->{data} // '';
            my $repeat = $r->{repeat} // 1;
            write_file($name, $data x $repeat);
        }

        plan tests => $tests;

        my $response = $test->{response};
        my $tx =
          $t->ua->build_tx(
            $request->{method} => $request->{url} => ($request->{headers} // {}) => ($request->{type} // 'json') =>
              $request->{body});
      SKIP: {
            if ($ENV{SELF_UPDATE}) {
                my $result = app()->ua->start($tx)->result;

                $response->{status} = $result->code;
                $response->{body}   = $result->json;

                skip 'Run in self update mode' => 3;
            } else {
                $t->request_ok($tx)->status_is($response->{status})->json_is($response->{body});
            }
        }
    };
}

write_file($tjson_file, $shebang, Cpanel::JSON::XS->new->utf8->allow_nonref->pretty->canonical->encode($tjson))
  if $ENV{SELF_UPDATE};

done_testing(scalar(@{$tjson->{tests}}));
