package Field::account;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PaymentInfo
  Type::input
  );

use Utils;
use Yandex::Balance;

sub _get_id {
    return 'account';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Расчетный счет', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
        'Расчетный счет лица, с которым будет заключен договор.',
        $self->{_language});
}

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    if ($result) {
        my $deps = $extra->{dependencies};
        $result = check_account($deps->{bik}, $value);
    }

    return {
        is_valid => !!$result,
        (
            $result
            ? ()
            : (description =>
                  gettext('Номер счета не соответствует БИК', $self->{_language}))
        ),
    };
}

sub _get_json_schema {
    return {
        type      => 'string',
        pattern   => '^[0-9]{20}$',
        minLength => 20,
        maxLength => 20,
    };
}

sub get_dependencies {
    my ($self) = @_;

    return ['bik'];
}

1;
