package Field::account_owner;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PaymentInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'account_owner';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Владелец счета', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Фамилия и имя владельца счета. Латиницей.', $self->{_language});
}

sub _get_json_schema {
    return {
        maxLength => 100,
        minLength => 1,
        pattern   => '^[a-zA-Z0-9][a-zA-Z0-9 \-\.]*[a-zA-Z0-9\.]$',
        type      => 'string',
    };
}

1;
