package Field::accountant_last_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::input
  );

use Utils;

sub _get_id {
    my ($self) = @_;
    return 'accountant_last_name';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Фамилия', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Как в паспорте.', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
        pattern   => '\S+',
    };
}

1;
