package Field::accountant_patronymic_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'accountant_patronymic_name';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Отчество', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Как в паспорте.', $self->{_language});
}

sub _get_json_schema {
    return {type => 'string',};
}

sub get_value {
    ''
}

1;
