package Field::accountant_phone;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::phone
  );

use Utils;

sub _get_id {
    return 'accountant_phone';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Номер телефона', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('В формате +X XXX XXXXXXX.', $self->{_language});
}

sub get_style {
    my ($self) = @_;
    return ($self->{version} == 2 ? 'short' : undef);
}

1;
