package Field::ag_ur_organization_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Company
  Type::input
  );

use Utils;

sub _get_id {
    return 'ag_ur_organization_name';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Название организации', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Как в свидетельстве о постановке на учет в налоговом органе. Латиницей.',
        $self->{_language}
    );
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
        maxLength => 200,
        pattern   => '^(?=.*[^\s0-9&\'\"])[a-zA-Z0-9\'\"][a-zA-Z0-9\s\-\.&\'\"]*[a-zA-Z0-9\.\'\"]$',
    };
}

1;
