package Field::allow_storage_and_processing_personal_data;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Confirmation
  Type::boolean_true
  );

use Utils;

sub _get_id {
    return 'allow_storage_and_processing_personal_data';
}

sub _get_name {
    my ($self) = @_;
    return gettext(
'Даю согласие на обработку и хранение моих персональных данных',
        $self->{_language}
    );
}

sub get_value {
    return JSON::XS::true;
}

1;
