package Field::city;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Address
  Type::input
  );

use Utils;

sub _get_id {
    return 'city';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Город', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
    };
}

sub get_hint {
    my ($self) = @_;
    return gettext('Город или населенный пункт проживания.', $self->{_language});
}

1;
