package Field::cyrillic_representative_first_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::SignerPerson
  Type::cyrillic_first_name
  );

use Utils;

sub _get_id {
    return 'cyrillic_representative_first_name';
}

sub get_value {
    my ($self, $user_data) = @_;

    return ($user_data->{dbfields}{'userinfo.firstname.uid'} // '');
}

sub get_style {
    my ($self) = @_;
    return ($self->{version} == 2 ? 'short' : undef);
}

1;
