package Field::date_of_birth;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::date_18
  );

use Utils;

sub _get_id {
    return 'date_of_birth';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Дата рождения', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return if $self->{version} == 2;
    return gettext('Дата рождения как в паспорте.', $self->{_language});
}

1;
