package Field::email;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::email
  );

use Utils;

sub _get_id {
    return 'email';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Email', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
        'Все отчетные документы будут отправляться на этот адрес.',
        $self->{_language});
}

sub get_style {
    my ($self) = @_;
    return ($self->{version} == 2 ? 'short' : undef);
}

1;
