package Field::freeform_address;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Address
  Type::textarea
  );

use Utils;

sub _get_id {
    return 'freeform_address';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Адрес', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Полный адрес, начиная с улицы.', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
        maxLength => 500,
    };
}

1;
