package Field::gdpr_warning;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Confirmation
  Type::gfm_text
  );

use Utils qw(gettext);

sub _get_id {
    return 'gdpr_warning';
}

sub _get_name {
    my ($self) = @_;
    return gettext(
'Если вы обязаны соответствовать требованиям Общего Регламента ЕС по Защите Данных 2016/679 от 27 апреля 2016 г. (GDPR), то к вашему сотрудничеству с Яндексом применяются положения обязательного документа Data Processing Agreement, доступного по ссылке <https://yandex.com/legal/yan_dpa_ch>',
        $self->{_language}
    );
}

sub get_style {
    return 'gdpr';
}

sub _get_json_schema {
    return {type => 'null',};
}

1;
