package Field::gender;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::SignerPerson
  Type::radio
  );

use Utils;

sub _get_id {
    return 'gender';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Пол', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Как в паспорте.', $self->{_language});
}

sub get_dictionary {
    my ($self) = @_;
    return [
        {
            value       => 'M',
            description => gettext('Мужской', $self->{_language}),
        },
        {
            value       => 'W',
            description => gettext('Женский', $self->{_language}),
        }
    ];
}

1;
