package Field::inn_ip;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Company
  Type::inn_ph
  );

use Utils;

sub _get_id {
    return 'inn_ip';
}

sub _get_name {
    my ($self) = @_;
    return gettext('ИНН', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Как в свидетельстве о регистрации физического лица в качестве ИП.',
        $self->{_language}
    );
}

1;
