package Field::inn_ph;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PartnerInfo
  Type::inn_ph
  );

use Utils;

sub _get_id {
    return 'inn_ph';
}

sub _get_name {
    my ($self) = @_;
    return gettext('ИНН', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Узнать ИНН можно на сайте или в налоговой службе по месту жительства.',
        $self->{_language}
    );
}

1;
