package Field::inn_ur;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Company
  Type::inn_ur
  );

use Utils;

sub _get_id {
    return 'inn_ur';
}

sub _get_name {
    my ($self) = @_;
    return gettext('ИНН', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Как в свидетельстве о постановке на учет в налоговом органе.',
        $self->{_language}
    );
}

1;
