package Field::kpp;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PaymentInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'kpp';
}

sub _get_name {
    my ($self) = @_;
    return gettext('КПП', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Как в свидетельстве о постановке на учет в налоговом органе.',
        $self->{_language}
    );
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 9,
        maxLength => 9,
        pattern   => '^[0-9]{9}$',
    };
}

1;
