package Field::latin_account;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PaymentInfo
  Type::input
  );

use Utils;
use Yandex::Balance;

sub _get_id {
    return 'latin_account';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Расчетный счет', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        pattern   => '^[A-Z0-9]+$',
        minLength => 4,
        maxLength => 30,
    };
}

1;
