package Field::latin_bank_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PaymentInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'latin_bank_name';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Наименование банка', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Название банка получателя. Латиницей.', $self->{_language});
}

sub _get_json_schema {
    return {
        maxLength => 100,
        minLength => 4,
        pattern   => '^(?=.*[^\s0-9])[a-zA-Z0-9][a-zA-Z0-9\s\-\.]+[a-zA-Z0-9\.]$',
        type      => 'string',
    };
}

1;
