package Field::latin_city;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Address
  Type::input
  );

use Utils;

sub _get_id {
    return 'latin_city';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Город', $self->{_language});
}

sub _get_json_schema {
    return {
        maxLength => 100,
        minLength => 1,
        pattern   => '^(?=.*[^\s0-9])[a-zA-Z0-9][a-zA-Z0-9\s\-\.,]*[a-zA-Z0-9\.]$',
        type      => 'string',
    };
}

sub get_hint {
    my ($self) = @_;
    return gettext('Город или населенный пункт проживания. Латиницей.',
        $self->{_language});
}

1;
