package Field::latin_freeform_address;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Address
  Type::textarea
  );

use Utils;

sub _get_id {
    return 'latin_freeform_address';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Адрес', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Полный адрес, начиная с улицы. Латиницей.', $self->{_language});
}

sub _get_json_schema {
    return {
        maxLength => 500,
        minLength => 1,
        pattern   => '^(?=.*[^\s0-9])[a-zA-Z0-9][a-zA-Z0-9\s\-\.,/]*[a-zA-Z0-9\.]$',
        type      => 'string',
    };
}

1;
