package Field::latin_lastname;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::input
  );

use Utils qw(gettext);

sub _get_id {
    return 'latin_lastname';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Фамилия', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Фамилия как в паспорте. Латиницей.', $self->{_language});
}

sub get_style {
    my ($self) = @_;
    return ($self->{version} == 2 ? 'short' : undef);
}

sub _get_json_schema {
    return {
        maxLength => 100,
        minLength => 1,
        pattern   => '^(?=.*[^\s0-9])[a-zA-Z0-9][a-zA-Z0-9\s\-\.]*[a-zA-Z0-9\.]$',
        type      => 'string',
    };
}

sub get_value {
    my ($self, $user_data) = @_;

    return ($user_data->{dbfields}{'userinfo.lastname.uid'} // '');
}

1;
