package Field::latin_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::input
  );

use Utils;

sub _get_id {
    my ($self) = @_;
    return 'latin_name';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Имя', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Имя как в паспорте. Латиницей.', $self->{_language});
}

sub get_style {
    my ($self) = @_;
    return ($self->{version} == 2 ? 'short' : undef);
}

sub _get_json_schema {
    return {
        maxLength => 100,
        minLength => 1,
        pattern   => '^(?=.*[^\s0-9])[a-zA-Z0-9][a-zA-Z0-9\s\-\.]*[a-zA-Z0-9\.]$',
        type      => 'string',
    };
}

sub get_value {
    my ($self, $user_data) = @_;

    return ($user_data->{dbfields}{'userinfo.firstname.uid'} // '');
}

1;
