package Field::mail_city;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Abc::BY
  Field::Groups::MailAddress
  Type::input
  );

use Carp;

use Utils;

sub _get_id {
    return 'mail_city';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Город', $self->{_language});
}

sub _get_json_schema {
    my ($self) = @_;

    croak 'Need to inherit from Abc::* or implement "get_abc" method' if !$self->can('get_abc');

    return {
        type      => 'string',
        minLength => 1,
        pattern   => sprintf(q<^[-'\d\s\.,%1$s]+$>, $self->get_abc()),
    };
}

1;
