package Field::mail_freeform_address;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Abc::BY
  Field::Groups::MailAddress
  Type::textarea
  );

use Carp;

use Utils;

sub _get_id {
    return 'mail_freeform_address';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Адрес', $self->{_language});
}

sub _get_json_schema {
    my ($self) = @_;

    croak 'Need to inherit from Abc::* or implement "get_abc" method' if !$self->can('get_abc');

    return {
        type      => 'string',
        minLength => 1,
        maxLength => 500,
        pattern   => sprintf(q<^[-'\d\s\.,/%1$s]+$>, $self->get_abc()),
    };
}

1;
