package Field::mail_zip_code;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::MailAddress
  Type::input
  );

use Utils;

sub _get_id {
    return 'mail_zip_code';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Индекс', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        maxLength => 20,
        pattern   => '^[a-zA-Z0-9 ]+$',
    };
}

1;
