package Field::name_change_warning;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::ContactInfo
  Type::gfm_text
  );

use Utils qw(gettext);

sub _get_id {
    return 'name_change_warning';
}

sub _get_name {
    my ($self) = @_;
    return gettext(
'Чтобы изменить фамилию, имя и отчество обратитесь в&nbsp; <a href=\"https://yandex.ru/support/partner2/support.html\" target=\"_blank\">службу поддержки</a>',
        $self->{_language}
    );
}

sub _get_json_schema {
    return {type => 'null',};
}

1;
