package Field::ogrnip;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Company
  Type::ogrnip
  );

use Utils;

sub _get_id {
    return 'ogrnip';
}

sub _get_name {
    my ($self) = @_;
    return gettext('ОГРН', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Как в свидетельстве о регистрации физического лица в качестве ИП.',
        $self->{_language}
    );
}

1;
