package Field::organization_id;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Company
  Type::input
  );

use Utils;

sub _get_id {
    return 'organization_id';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Номер свидетельства', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Как в свидетельстве о государственной регистрации.',
        $self->{_language});
}

sub _get_json_schema {
    return {
        minLength => 1,
        pattern   => '^[a-zA-Z0-9][a-zA-Z0-9 \-\.]*[a-zA-Z0-9\.]$',
        type      => 'string',
    };
}

1;
