package Field::organization_type;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Company
  Type::select
  );

use Utils;

sub _get_id {
    return 'organization_type';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Тип организации', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Правовая форма вашей организации.', $self->{_language});
}

sub normalize {
    my ($self, $value) = @_;

    $value = '' if $value eq 'Другая';

    return $value;
}

sub get_dictionary {
    my ($self) = @_;
    return [
        {
            value       => 'ООО',
            description => 'ООО',
        },
        {
            value       => 'ЗАО',
            description => 'ЗАО',
        },
        {
            value       => 'ОАО',
            description => 'ОАО',
        },
        {
            value       => 'Другая',
            description => 'Другая',
        }
    ];
}

1;
