package Field::organization_type_belarus_ip;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Field::Groups::Company Type::select);

use Utils;

sub _get_id {
    return 'organization_type_belarus_ip';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Тип организации', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Правовая форма вашей организации.', $self->{_language});
}

sub get_dictionary {
    my ($self) = @_;
    return [
        {
            value       => 'ИП',
            description => 'Индивидуальный предприниматель',
        },
    ];
}

sub get_value {
    my ($self) = @_;
    return $self->get_dictionary()->[0]{value};
}

1;
