package Field::organization_type_other_wo_ip;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Field::Groups::Company Type::input Abc::BY);

use Carp;

use Utils;

sub _get_id {
    return 'organization_type_other_wo_ip';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Другой тип организации', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Правовая форма вашей организации.', $self->{_language});
}

sub get_conditions {
    # "Другая" - для фронта, для сырых данных
    # ""       - для бека, после нормализации
    return {organization_type_belarus_wo_ip => ['', 'Другая'],};
}

sub _get_json_schema {
    my ($self) = @_;

    croak 'Need to inherit from Abc::* or implement "get_abc" method' if !$self->can('get_abc');

    return {
        type      => 'string',
        minLength => 1,
        pattern   => sprintf(q<^[-'\d\s\.,%1$s]+$>, $self->get_abc()),
    };
}

1;
