package Field::pfr;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PartnerInfo
  Type::pfr
  );

use Utils;

sub _get_id {
    return 'pfr';
}

sub _get_name {
    my ($self) = @_;
    return gettext('СНИЛС', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'В формате XXX-XXX-XXX XX. Получить СНИЛС можно в пенсионном фонде по месту жительства.',
        $self->{_language}
    );
}

1;
