package Field::representative_document_type;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::SignerPerson
  Type::select
  );

use Utils;

sub _get_id {
    return 'representative_document_type';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Тип документа', $self->{_language});
}

sub get_dictionary {
    my ($self) = @_;
    return [
        {
            value       => 'Устав',
            description => gettext('Устав', $self->{_language}),
        },
        {
            value       => 'Доверенность',
            description => gettext('Доверенность', $self->{_language}),
        },
        {
            value       => 'Приказ',
            description => gettext('Приказ', $self->{_language}),
        },
        {
            value       => 'Распоряжение',
            description => gettext('Распоряжение', $self->{_language}),
        },
        {
            value       => 'Положение о филиале',
            description => gettext('Положение о филиале', $self->{_language}),
        },
        {
            value       => 'Свидетельство о регистрации',
            description => gettext('Свидетельство о регистрации', $self->{_language}),
        },
        {
            value       => 'Договор',
            description => gettext('Договор', $self->{_language}),
        },
    ];
}

1;
