package Field::representative_last_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::SignerPerson
  Type::input
  );

use Utils;

sub _get_id {
    return 'representative_last_name';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Фамилия', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Как в паспорте.', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
        pattern   => '\S+',
    };
}

1;
