package Field::representative_position;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::SignerPerson
  Type::input
  );

use Utils;

sub _get_id {
    return 'representative_position';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Должность', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Должность лица, с которым будет заключен договор.',
        $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
    };
}

1;
