package Field::representative_position_other;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Abc::RU
  Field::Groups::SignerPerson
  Type::input
  );

use Carp;

use Utils;

sub _get_id {
    return 'representative_position_other';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Название должности', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Только кириллицей.', $self->{_language});
}

sub get_conditions {
    # "Другая" - для фронта, для сырых данных
    # ""       - для бека, после нормализации
    return {representative_position_ur => ['', 'Другая'],};
}

sub _get_json_schema {
    my ($self) = @_;

    croak 'Need to inherit from Abc::* or implement "get_abc" method' if !$self->can('get_abc');

    return {
        type      => 'string',
        minLength => 1,
        pattern   => sprintf(q<^[-'\d\s\.,%1$s]+$>, $self->get_abc()),
    };
}

1;
