package Field::representative_position_ur;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::SignerPerson
  Type::select
  );

use Utils;

sub _get_id {
    return 'representative_position_ur';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Должность', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Должность лица, с которым будет заключен договор.',
        $self->{_language});
}

sub normalize {
    my ($self, $value) = @_;

    $value = '' if $value eq 'Другая';

    return $value;
}

sub get_dictionary {
    my ($self) = @_;

    my $lang = ref $self ? $self->{_language} : 'ru';

    return [
        {
            value       => "Генеральный директор",
            description => gettext("Генеральный директор", $lang),
        },
        {
            value       => "Директор",
            description => gettext("Директор", $lang),
        },
        {
            value       => "Индивидуальный предприниматель",
            description => gettext("Индивидуальный предприниматель", $lang),
        },
        {
            value       => "Исполнительный директор",
            description => gettext("Исполнительный директор", $lang),
        },
        {
            value       => "Заместитель генерального директора",
            description => gettext("Заместитель генерального директора", $lang),
        },
        {
            value       => "Президент",
            description => gettext("Президент", $lang),
        },
        {
            value       => "Коммерческий директор",
            description => gettext("Коммерческий директор", $lang),
        },
        {
            value       => "Председатель правления",
            description => gettext("Председатель правления", $lang),
        },
        {
            value       => "Финансовый директор",
            description => gettext("Финансовый директор", $lang),
        },
        {
            value       => "Ректор",
            description => gettext("Ректор", $lang),
        },
        {
            value       => "Управляющий директор",
            description => gettext("Управляющий директор", $lang),
        },
        {
            value       => "Директор по маркетингу и развитию",
            description => gettext("Директор по маркетингу и развитию", $lang),
        },
        {
            value       => 'Другая',
            description => gettext("Другая", $lang),
        }
    ];
}

1;
