package Field::roles;

use strict;
use warnings FATAL => 'all';

use utf8;
use open qw(:std :utf8);

use base qw(Type::multiselect);

use Utils;

sub _get_id {
    return 'roles';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Что вы хотите монетизировать?', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Выберите объект монетизации: сайты или приложения (или оба вида).',
        $self->{_language}
    );
}

sub get_group_name {
    my ($self) = @_;
    return gettext('Монетизация', $self->{_language});
}

sub get_dictionary {
    my ($self) = @_;

    return [
        {
            value       => '9',
            description => gettext('Сайты', $self->{_language}),
        },
        {
            value       => '27',
            description => gettext('Приложения', $self->{_language}),
        }
    ];
}

1;
