package Field::russian_passport_issuer;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PartnerInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'russian_passport_issuer';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Кем выдан', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
    };
}

1;
