package Field::russian_passport_issuer_code;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PartnerInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'russian_passport_issuer_code';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Код подразделения', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('В формате XXX-XXX.', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 7,
        maxLength => 7,
        pattern   => '^[0-9]{3}-[0-9]{3}$',
    };
}

1;
