package Field::russian_passport_number;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PartnerInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'russian_passport_number';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Номер паспорта', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 6,
        maxLength => 6,
        pattern   => '^[0-9]{6}$',
    };
}

1;
